﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Facade;
using System.Web.Mvc;
using System.Text;
using InfoWorld.EVS.CTSMAPI;
using BMS.Utils;
using System.Drawing;
using System.IO;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// The Model class for the WardWhiteboard page.
    /// </summary>
    public class WardWhiteboardViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the division extension.
        /// </summary>
        /// <value>
        /// The division extension.
        /// </value>
        public string DivisionExtension { get; set; }

        /// <summary>
        /// Gets or sets the name of the division.
        /// </summary>
        /// <value>
        /// The name of the division.
        /// </value>
        public string DivisionName { get; set; }

        /// <summary>
        /// Gets or sets the selected division.
        /// </summary>
        /// <value>
        /// The selected division.
        /// </value>
        public Division SelectedDivision { get; set; }

        /// <summary>
        /// Gets or sets the division list.
        /// </summary>
        /// <value>
        /// The division list.
        /// </value>
        public IList<Division> DivisionList { get; set; }

        /// <summary>
        /// Gets or sets the split screen.
        /// </summary>
        /// <value>
        /// The split screen.
        /// </value>
        public string SplitScreen { get; set; }

        /// <summary>
        /// Gets or sets the split screen selected status.
        /// </summary>
        /// <value>
        /// The split screen selected status.
        /// </value>
        public bool SplitScreenSelected { get; set; }

        /// <summary>
        /// Gets or sets the split screen list.
        /// </summary>
        /// <value>
        /// The split screen list.
        /// </value>
        public CDList StrictDecisionList { get; set; }

        /// <summary>
        /// Gets or sets the display PT.
        /// </summary>
        /// <value>
        /// The display PT.
        /// </value>
        public string DisplayPT { get; set; }

        /// <summary>
        /// Gets or sets the code of the display PT.
        /// </summary>
        /// <value>
        /// The code of the display PT.
        /// </value>
        public string DisplayPTCode { get; set; }

        /// <summary>
        /// Gets or sets the display PT list.
        /// </summary>
        /// <value>
        /// The display PT list.
        /// </value>
        public CDList DisplayPTList { get; set; }
        /// <summary>
        /// Gets or sets the color of the gender.
        /// </summary>
        /// <value>
        /// The color of the gender.
        /// </value>
        public string GenderColor { get; set; }

        /// <summary>
        /// Gets or sets the code of the gender color.
        /// </summary>
        /// <value>
        /// The code of the gender color.
        /// </value>
        public string GenderColorCode { get; set; }

        /// <summary>
        /// Gets or sets the gender color list.
        /// </summary>
        /// <value>
        /// The gender color list.
        /// </value>
        public CDList GenderColorList { get; set; }

        /// <summary>
        /// Gets or sets the whiteboard list.
        /// </summary>
        /// <value>
        /// The whiteboard list.
        /// </value>
        public IList<WhiteboardBedInfo> WhiteboardList { get; set; }

        /// <summary>
        /// Gets or sets the last updated date.
        /// </summary>
        /// <value>
        /// The last updated date.
        /// </value>
        public string LastUpdatedDate { get; set; }

        /// <summary>
        /// Gets or sets the facility site time zone.
        /// </summary>
        /// <value>
        /// The facility site time zone.
        /// </value>
        public string FacilitySiteCodeTimeZone { get; set; }

        /// <summary>
        /// Gets or sets the refresh page rate.
        /// </summary>
        /// <value>
        /// The refresh page rate.
        /// </value>
        public string RefreshPageRate { get; set; }

        /// <summary>
        /// Gets or sets the facility's occupancy percent.
        /// </summary>
        /// <value>
        /// The facility's occupancy percent.
        /// </value>
        public int FacilityOccupancyPercent { get; set; }

        /// <summary>
        /// Gets or sets the division's occupancy percent.
        /// </summary>
        /// <value>
        /// The division's occupancy percent.
        /// </value>
        public int DivisionOccupancyPercent { get; set; }

        /// <summary>
        /// Gets or sets the sort by list.
        /// </summary>
        /// <value>
        /// The sort by list.
        /// </value>
        public List<string> SortByList { get; set; }

        /// <summary>
        /// Gets or sets the display staff attending list.
        /// </summary>
        /// <value>
        /// The display staff attending list.
        /// </value>
        public List<string> DisplayStaffAttendingList { get; set; }

        /// <summary>
        /// Gets or sets the display staff attending selected.
        /// </summary>
        /// <value>
        /// The display staff attending selected.
        /// </value>
        public string DisplayStaffAttendingSelected { get; set; }

        /// <summary>
        /// Gets or sets the sort by selected.
        /// </summary>
        /// <value>
        /// The sort by selected.
        /// </value>
        public string SortBySelected { get; set; }

        /// <summary>
        /// Gets or sets the patients waiting count.
        /// </summary>
        /// <value>
        /// The patients waiting count.
        /// </value>
        public PatientWaitingCount PatientsWaitingCount { get; set; }

        /// <summary>
        /// Gets or sets the ward group census list.
        /// </summary>
        /// <value>
        /// The ward group census list.
        /// </value>
        public IList<WardGroupCensus> WardGroupCensusList { get; set; }

        /// <summary>
        /// Gets or sets the URL for the report.
        /// </summary>
        /// <value>
        /// The ward whiteboard report URL.
        /// </value>
        public string WardWhiteboardReportUrl { get; set; }

        /// <summary>
        /// Gets or sets the icon information list.
        /// </summary>
        /// <value>
        /// The icon information list.
        /// </value>
        public List<IconInfo> IconFlagsList { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to display the footer census or not.
        /// </summary>
        /// <value>
        /// The value indicating whether to display the footer census or not.
        /// </value>
        public string DisplayFooterCensus { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to display the footer census or not.
        /// </summary>
        /// <value>
        /// The value indicating whether to display the footer census or not.
        /// </value>
        public bool DisplayFooterCensusSelected { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [user has update staff permission].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [user has update staff permission]; otherwise, <c>false</c>.
        /// </value>
        public bool UserHasUpdateStaffPermission { get; set; }

        /// <summary>
        /// Gets or sets the display scroll selected.
        /// </summary>
        /// <value>
        /// The display scroll selected.
        /// </value>
        public string DisplayScrollSelected { get; set; }

        /// <summary>
        /// Gets or sets the scroll rate selected.
        /// </summary>
        /// <value>
        /// The scroll rate selected.
        /// </value>
        public int ScrollRateSelected { get; set; }

        /// <summary>
        /// Gets or sets the scroll rate list.
        /// </summary>
        /// <value>
        /// The scroll rate list.
        /// </value>
        public Dictionary<int, string> ScrollRateList { get; set; }

        /// <summary>
        /// Gets or sets the actual scroll value.
        /// </summary>
        /// <value>
        /// The actual scroll value.
        /// </value>
        public decimal ActualScrollValue { get; set; }

        /// <summary>
        /// Gets or sets the actual scroll direction.
        /// </summary>
        /// <value>
        /// The actual scroll direction.
        /// </value>
        public int ActualScrollDirection { get; set; }

        /// <summary>
        /// Gets or sets the facility settings.
        /// </summary>
        /// <value>
        /// The facility settings.
        /// </value>
        public FacilitySettings FacilitySettings { get; set; }

        /// <summary>
        /// Gets or sets the button refresh hidden.
        /// </summary>
        /// <value>
        /// The button refresh hidden.
        /// </value>
        public string ButtonRefreshHidden { get; set; }

        /// <summary>
        /// Gets or sets the facility code.
        /// </summary>
        /// <value>
        /// The facility code.
        /// </value>
        public string FacilityCode { get; set; }

        /// <summary>
        /// Gets or sets the is from whiteboard kiosk.
        /// </summary>
        /// <value>
        /// The is from whiteboard kiosk.
        /// </value>
        public string IsFromWhiteboardKiosk { get; set; }

        /// <summary>
        /// Gets or sets the ajax refresh count.
        /// </summary>
        /// <value>
        /// The ajax refresh count.
        /// </value>
        public string AjaxRefreshCount { get; set; }

        /// <summary>
        /// Gets or sets the real refresh rate.
        /// </summary>
        /// <value>
        /// The real refresh rate.
        /// </value>
        public string RealRefreshRate { get; set; }
    }    

    /// <summary>
    /// WardGroup Census numbers.
    /// </summary>
    public class WardGroupCensus
    {
        /// <summary>
        /// Gets or sets the occupied beds.
        /// </summary>
        /// <value>
        /// The occupied beds.
        /// </value>
        public int OccupiedBeds { get; set; }

        /// <summary>
        /// Gets or sets the assigned beds.
        /// </summary>
        /// <value>
        /// The assigned beds.
        /// </value>
        public int AssignedBeds { get; set; }

        /// <summary>
        /// Gets or sets the unassigned beds.
        /// </summary>
        /// <value>
        /// The unassigned beds.
        /// </value>
        public int AvailableBeds { get; set; }

        /// <summary>
        /// Gets or sets the male beds.
        /// </summary>
        /// <value>
        /// The male beds.
        /// </value>
        public int MaleBeds { get; set; }

        /// <summary>
        /// Gets or sets the female beds.
        /// </summary>
        /// <value>
        /// The female beds.
        /// </value>
        public int FemaleBeds { get; set; }

        /// <summary>
        /// Gets or sets the total beds.
        /// </summary>
        /// <value>
        /// The total beds.
        /// </value>
        public int TotalBeds { get; set; }

        /// <summary>
        /// Gets or sets the ward group.
        /// </summary>
        /// <value>
        /// The ward group.
        /// </value>
        public string WardGroup { get; set; }        
    }

    public class EditStaffViewModel
    {
        public string BedId { get; set; }

        [ValidateXss]
        public string Staff { get; set; }

        public string PatientId { get; set; }
    }
}
